//---------------------------------------------------------------------------
#ifndef stereoH
#define stereoH

#include "relatyw3d.h"
#include "geometria.h"                  //TPunkt, TLinia
#include "natura.h"
//---------------------------------------------------------------------------
//  Rodzaje technicznego przygotowania stereogramw
enum StylPatrzenia {
    Zezem,                              //Lewy obrazek z prawej strony i odwrotnie
    Peryskopy,                          //Lewy z lewej, prawy z prawej
    Anaglif};                           //dwa obrazki w tym samym miejscu, wymagane okulary
//---------------------------------------------------------------------------
//  Postrzeganie dwuoczne.
class TRelatywStereo
{
 private:
    TRelatyw3d *L, *R;                  //projekcje dla lewego i prawego oka
 public:
    TRelatywStereo( TPunkt obs,         //pozycja obserwatora
        int xe0, int ye0, int eszer, int ewys, //okno ekranowe
        double v,                       //prdko w kierunku osi 'x'
        double baza,                    //odlego midzy oczami
        TCanvas *cnv,                   //aparat graficzny
        StylPatrzenia sp=Zezem,         //typ okularw stereo
        double odl_ekr=0.5);
    ~TRelatywStereo();                  //destruktor zlikwiduje obiekty spod wskanikw L, R

    bool punkt_stereo( TPunkt p,
        TColor Lkolor=clBlack, TColor Rkolor=clBlack);
    bool linia_stereo( TPunkt p1, TPunkt p2, int il_podzial,
        TColor Lkolor=clBlack, TColor Rkolor=clBlack);
    bool czworokat_stereo( TPunkt p1, TPunkt p2, TPunkt p3, TPunkt p4,
        int il_podzial,
        TColor Lkolor1=clBlack, TColor Rkolor1=clBlack,     //kolory konturw
        TColor Lkolor2=clWhite, TColor Rkolor2=clWhite);    //kolory wypenie
};
#endif
